#include "GlobalExtern.h"

void LoadGuide(char* p, char* n) {
	//////////dprintf("Guide Start\n");
	//////////dprintf("Guide: %s\n", p);
	guideGameSelectedText = GameGuideLines / 2;
	guide.clear();
	ifstream f(p);
	if(!f) {
		//////////dprintf("Guide not found\n");
		guide.push_back("No game information found");
		return;
	}
	//////////dprintf("Guide found\n");
	while(!f.eof()) {
		char line[2048];
		for(int i = 0; i < 2048; i++) line[i] = '\0';
		f.getline(line, 2048);
		string t = line;
		for(int i = 0; i < t.size(); i++) {
			if((t.c_str())[i] == '\t') t[i] = ' ';
			if((t.c_str())[i] == 0xAF) t[i] = '-';
		}
		guide.push_back(t);
	}
	f.close();
	//////////dprintf("Guide End\n");
}

bool operator<(const guideDBEntry &l, const guideDBEntry &r) {
	std::string a = l.name;
	std::string b = r.name;
	transform(a.begin(), a.end(), a.begin(), tolower);
	transform(b.begin(), b.end(), b.begin(), tolower);
	if(a < b) return true; else return false;
}

void SearchDirectoryText(std::string pathToSearch) {
	guideDatabase.clear();
	std::string path1 = pathToSearch;// + "*";
	std::string path2("*.txt");
	std::string path = path1 + path2;
	HANDLE find=NULL;
	WIN32_FIND_DATA wfd;
	memset(&wfd,0,sizeof(wfd));
	find=FindFirstFile(path.c_str(),&wfd);
	if (find ==INVALID_HANDLE_VALUE){ //Empty directory
		guideDBEntry t, t2;
		t.name = "No text files were found in D:\\guides";
		t.path = "C:\\Test";
		guideDatabase.push_back(t);
		t2.name = "Game guides can be found at http:\\\\www.gamefaqs.com";
		t2.path = "C:\\Test";
		guideDatabase.push_back(t2);	
		return;
	}
	do {
		if(!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) { 
			std::string fileFound(wfd.cFileName);
			guideDBEntry f;
			f.name = fileFound;
			for(int i = 0; i < f.name.size(); i++) {
				if((   (f.name.c_str())[i] == '.' 
					&& (f.name.c_str())[i+1] == 't' 
					&& (f.name.c_str())[i+2] == 'x' 
					&& (f.name.c_str())[i+3] == 't' 
					&& (f.name.c_str())[i+4] == '\0') 
					) {
						f.name[i] = '\0';
						break;
				}
			}
			f.path = pathToSearch + fileFound;
			guideDatabase.push_back(f);	
		}
	} while (FindNextFile(find,&wfd) !=0);
	sort(guideDatabase.begin(), guideDatabase.end());
}

void DrawGuide() {
	int y = 50;
	DWORD color;
	int start = 0;
	if(guideGameSelectedText > (GameGuideLines/2) && (guide.size() > GameGuideLines)) {
		start += (guideGameSelectedText  - (GameGuideLines/2));
	}
	int aSelected = guideGameSelectedText;
	int bSizeMinus7 = ((guide.size()-1) - (GameGuideLines/2));
	if((aSelected > bSizeMinus7) && (guide.size() > GameGuideLines)) {
		start = (guide.size() - GameGuideLines);
	}
	if(GameGuideColor == 0)
		color = 0xff00ff00; 
	else
		color = 0xffffffff; 
	for(int i = start; i <  start + GameGuideLines; i++) {
		if(i == guide.size()) { return; }
		WCHAR msg[2048]={0};
		std::string t = guide[i];
		for(int r = 0; r < 2048; r++) {
			if((t.c_str())[r] == '\0') {
				msg[r] = '\0';
				break;
			} 
			msg[r] = (t.c_str())[r]; 
		}
		FontSetColour(color);
		FontGuideText(msg,guideLeft, y, GameGuideWidth);
		y+=GameGuideVSpace;
	}
}

void GuideListInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		if(!Emulation) {
			fadeOption = 1;
			fadeColor = 255;
			GUIState = MAIN_MENU;
			MenuSelected = 4;
			MenuBackground();
		}
		else {
			GUIState = ROM_SELECT;
		}
		return;          
	} 
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		guideGameSelected++; 
		if(guideGameSelected >= guideDatabase.size()) 
			guideGameSelected = guideDatabase.size() - 1;
	}
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		guideGameSelected--; 
		if(guideGameSelected < 0) 
			guideGameSelected = 0;
	}  
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(!disableMenuSounds) ConfirmSound();
		LoadGuide((char*)guideDatabase[guideGameSelected].path.c_str(),
			(char*)guideDatabase[guideGameSelected].name.c_str());
		while(true) {
			updateEffect();
			ReadInput();
			if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
				CancelSound();
				SetFontHeight(FontSize);
				guide.clear();
				
				return;          
			} 
			if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
				ClickSound();
				if(guideGameSelectedText < 7) guideGameSelectedText = 7;
				guideGameSelectedText++; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
			}
			if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {  
				ClickSound();
				guideGameSelectedText--; if(guideGameSelectedText < 7) guideGameSelectedText = 7;
			}  
			if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT)  {
				if(guideGameSelectedText < 7) guideGameSelectedText = 7;
				guideGameSelectedText+=GameGuideLines; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
			}
			if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT)  {  
				guideGameSelectedText-=GameGuideLines; if(guideGameSelectedText < 7) guideGameSelectedText = 7;
			}  
			if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
				if(slowGuide >= 1) { 
					slowGuide = 0; 
				} 
				if(rightAnalog == 255)
					slowGuide = scrollSpeed;
				else
					slowGuide += ((float)rightAnalog/255.0f);
				guideGameSelectedText+=((int)slowGuide); 
				if(guideGameSelectedText >= guide.size()) 
					guideGameSelectedText = guide.size() - 1;
			}
			if (g_Gamepads[DefaultController].fX1 < 0) {guideLeft-=2;  } // Left
			if (g_Gamepads[DefaultController].fX1 > 0) {guideLeft+=2;  }// Right
			if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
				if(slowGuide >= 1)  { 
					slowGuide = 0;
				}
				if(leftAnalog == 255)
					slowGuide = scrollSpeed;
				else
					slowGuide += ((float)leftAnalog/255.0f);
				guideGameSelectedText-=((int)slowGuide); 
				if(guideGameSelectedText < 7)
					guideGameSelectedText = 7;
			}
			Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			SetFontHeight(GameGuideFontSize);
			DrawGuide();
			SetFontHeight(FontSize);
			Present();
		}
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(slow >= 1) { 
			slow = 0; 
		} 
		if(rightAnalog == 255)
			slow = scrollSpeed;
		else
			slow += ((float)rightAnalog/255.0f);
		guideGameSelected+=((int)slow); 
		if(guideGameSelected >= guideDatabase.size()) 
			guideGameSelected = guideDatabase.size() - 1;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(slow >= 1)  { 
			slow = 0;
		}
		if(leftAnalog == 255)
			slow = scrollSpeed;
		else
			slow += ((float)leftAnalog/255.0f);
		guideGameSelected-=((int)slow); if(guideGameSelected < 0) guideGameSelected = 0;
	}
	return;
} 

void DrawGameGuideList() {
	int y = MenuPosY;
	DWORD color;
	int start = 0;
	if(guideGameSelected > 7 && (guideDatabase.size() > 15)) {
		start += (guideGameSelected  - 7);
	}
	if((guideGameSelected > ((guideDatabase.size()-1) - 7)) && (guideDatabase.size() > 15)) {
		start = (guideDatabase.size() - 15);
	}
	for(int i = start; i <  start +15; i++) {
		if(i == guideDatabase.size()) return;
		if(i ==guideGameSelected) color = 0xffff00; else color = 0xffffff; 
		WCHAR msg[1024]={0};
		std::string t = guideDatabase[i].name;
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				msg[r] = '\0';
				break;
			}
			msg[r] = (t.c_str())[r];
		}
		FontSetColour(color);
		FontCenteredText(msg, MenuPosX, y, 640);
		y+=vSpace;
	}
}

void DrawGuideListMenu() {
	if(!Emulation) {
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		Device->SetTexture(0,TexOption);
		DrawBackground();
		if(fadeColor > 0) {
			Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			fade = true;
			fadeColor -=fadeSpeed;
			if(fadeColor < fadeSpeed) { fadeColor = 0; }
			Device->SetTexture(0,TexMainMenu);
			DrawBackground();
			fade = false;
			Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
		}
		else {
			DrawGameGuideList();
		}
		Present();
	}
	else {
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		Device->SetTexture(0,TexOption);
		DrawBackground();
		DrawGameGuideList();
		Present();
	}
}

void GuideListMenu() {
	DrawGuideListMenu();
	GuideListInput();
}
